<?php defined('ALTUMCODE') || die() ?>

<form name="update_biolink_" method="post" role="form" enctype="multipart/form-data">
    <input type="hidden" name="token" value="<?= \Altum\Middlewares\Csrf::get() ?>" required="required" />
    <input type="hidden" name="request_type" value="update" />
    <input type="hidden" name="block_type" value="image_grid" />
    <input type="hidden" name="biolink_block_id" value="<?= $row->biolink_block_id ?>" />

    <div class="notification-container"></div>

    <div class="form-group">
        <label for="<?= 'image_grid_name_' . $row->biolink_block_id ?>"><i class="fa fa-fw fa-paragraph fa-sm text-muted mr-1"></i> <?= language()->create_biolink_link_modal->input->name ?></label>
        <input id="<?= 'image_grid_name_' . $row->biolink_block_id ?>" type="text" name="name" class="form-control" value="<?= $row->settings->name ?>" maxlength="128" />
    </div>

    <div class="form-group">
        <label for="<?= 'image_grid_' . $row->biolink_block_id ?>"><i class="fa fa-fw fa-image fa-sm text-muted mr-1"></i> <?= language()->create_biolink_image_grid_modal->image ?></label>
        <div data-image-container class="<?= !empty($row->settings->image) ? null : 'd-none' ?>">
            <div class="row">
                <div class="m-1 col-6 col-xl-3">
                    <img src="<?= $row->settings->image ? UPLOADS_FULL_URL . 'block_images/' . $row->settings->image : null ?>" class="img-fluid rounded <?= !empty($row->settings->image) ? null : 'd-none' ?>" loading="lazy" />
                </div>
            </div>
        </div>
        <input id="<?= 'image_grid_' . $row->biolink_block_id ?>" type="file" name="image" accept=".gif, .png, .jpg, .jpeg, .svg" class="form-control-file" />
    </div>

    <div class="form-group">
        <label for="<?= 'image_grid_image_alt_' . $row->biolink_block_id ?>"><i class="fa fa-fw fa-comment-dots fa-sm text-muted mr-1"></i> <?= language()->create_biolink_link_modal->input->image_alt ?></label>
        <input id="<?= 'image_grid_image_alt_' . $row->biolink_block_id ?>" type="text" class="form-control" name="image_alt" value="<?= $row->settings->image_alt ?>" maxlength="100" />
        <small class="form-text text-muted"><?= language()->create_biolink_link_modal->input->image_alt_help ?></small>
    </div>

    <div class="form-group">
        <label for="<?= 'image_grid_location_url_' . $row->biolink_block_id ?>"><i class="fa fa-fw fa-link fa-sm text-muted mr-1"></i> <?= language()->create_biolink_link_modal->input->location_url ?></label>
        <input id="<?= 'image_grid_location_url_' . $row->biolink_block_id ?>" type="text" class="form-control" name="location_url" value="<?= $row->location_url ?>" maxlength="2048" />
    </div>

    <div class="mt-4">
        <button type="submit" name="submit" class="btn btn-block btn-primary"><?= language()->global->update ?></button>
    </div>
</form>
