<?php

namespace Altum\Controllers;

use Altum\Response;
use Altum\Traits\Apiable;

class ApiLocation extends Controller
{
  use Apiable;

  public function index()
  {
    $this->verify_request();

    switch ($_SERVER['REQUEST_METHOD']) {
      case 'POST':
        $this->SendLocation();
        break;
    }

    $this->return_404();
  }

  public function SendLocation()
  {
    try {
      $data = json_decode(file_get_contents("php://input"), true);

      if (isset($data['latitude'], $data['longitude'], $data['user_mail'])) {
        $latitude = $data['latitude'];
        $longitude = $data['longitude'];
        $user_mail = $data['user_mail'];
        $api_key = "";

        $data = file_get_contents("https://maps.googleapis.com/maps/api/geocode/json?latlng=$latitude,$longitude&key=$api_key");
        $data = json_decode($data, true);

        if ($data['status'] === 'OK') {
          $data = $data['results'][0]['formatted_address'];

          $email_template = get_email_template(
            [],
            l('global.emails.ourbandkids_activation.subject'),
            [
              '{{LOCALIZATION}}' => $data,
            ],
            l("global.emails.ourbandkids_activation.body")
          );
          $mail = send_mail($user_mail, $email_template->subject, $email_template->body);

          /* Debug */
          $debug = [
            'send_mail' => $mail ? 'Mail sent successfully' : 'Failed to send mail',
            'latitude' => $latitude,
            'longitude' => $longitude,
            'address' => $data,
            'user_mail' => $user_mail,
          ];

          Response::jsonapi_success($debug);
        } else
          Response::jsonapi_error('Falha ao obter o endereco');
      } else {
        Response::jsonapi_error('Parametros invalidos: latitude, longitude e user_mail sao obrigatorios.');
      }
    } catch (\Exception $e) {
      Response::jsonapi_error($e->getMessage(), "entao ne");
    }
  }
}
