const form = document.getElementById("activation_form");

function submitForm(response) {
  const message = response.ok
    ? "<p class='font-2-l' style='grid-column: 1/-1; padding: 20px 1rem; border-radius: 4px; background: #fafafa;'><span style='color: #317A00;'>Formulário enviado</span>, você pode acessar sua conta em <a href='https://ourcard.eco/new/pt-BR.html'>OurCard.eco</a> para customizar seu link e muito mais!</p>"
    : "<p class='font-2-l' style='grid-column: 1/-1; padding: 20px 1rem; border-radius: 4px; background: #fafafa;'><span style='color: #E00000;'>Erro no envio</span>, você pode enviar diretamente para o nosso <a href='https://api.whatsapp.com/send?phone=5516981550065'>WhatsApp</a>.</p>";

  form.innerHTML = message;
}

async function createUser(event) {
  event.preventDefault();
  const submit_form = document.getElementById("submit_form");
  submit_form.disabled = true;
  submit_form.innerText = "Enviando...";

  const inputFields = form.querySelectorAll("[name]");
  const formData = new FormData();

  inputFields.forEach((field) => {
    // if (
    //   field.id === "name" ||
    //   field.id === "email" ||
    //   field.id === "password"
    // ) {
    const name = field.getAttribute("name");
    const value = field.value;
    formData.append(name, value);
    //}
  });

  const url = "https://ourcard.eco/admin-api/users";
  const apiKey = "06d0c25f5a4b6c21f36047931ab39e25";

  try {
    const response = await fetch(url, {
      method: "POST",
      headers: {
        Authorization: `Bearer ${apiKey}`,
      },
      body: formData,
    }).then(submitForm);

    formData.forEach((element) => {
      console.log(element);
    });
  } catch (error) {
    console.error("Erro ao processar a solicitação:", error);
    formData.forEach((element) => {
      console.log(element);
    });
  }
}

form.addEventListener("submit", createUser);
