<?php defined('ALTUMCODE') || die() ?>

<div data-biolink-block-id="<?= $data->link->biolink_block_id ?>" class="col-12 my-2">
  <a href="#" data-toggle="modal" data-target="<?= '#note_' . $data->link->biolink_block_id ?>" class="btn btn-block btn-primary link-btn link-hover-animation <?= 'link-btn-' . $data->link->settings->border_radius ?> <?= $data->link->design->link_class ?>" style="<?= $data->link->design->link_style ?>">
    <div class="link-btn-image-wrapper <?= 'link-btn-' . $data->link->settings->border_radius ?>" <?= $data->link->settings->image ? null : 'style="display: none;"' ?>>
      <img src="<?= $data->link->settings->image ? UPLOADS_FULL_URL . 'block_thumbnail_images/' . $data->link->settings->image : null ?>" class="link-btn-image" loading="lazy" />
    </div>

    <?php if ($data->link->settings->icon) : ?>
      <i class="<?= $data->link->settings->icon ?> mr-1"></i>
    <?php endif ?>

    <?= $data->link->settings->name ?>
  </a>
</div>

<?php ob_start() ?>
<div class="modal fade" id="<?= 'note_' . $data->link->biolink_block_id ?>" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">

      <div class="modal-header px-0 px-sm-3 mb-2 flex-wrap">
        <h5 class="modal-title"><?= $data->link->settings->name ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="<?= l('global.close') ?>">
          <span aria-hidden="true">&times;</span>
        </button>
        <div class="btn-block mt-2">
          <a class="btn btn-primary" href="<?= SITE_URL . "data" ?>" target="_blank"><svg class="mr-1" xmlns="http://www.w3.org/2000/svg" width="20" height="21" fill="none">
              <g clip-path="url(#a)">
                <g clip-path="url(#b)">
                  <path fill="#fff" d="M1.788 7.018A2.002 2.002 0 0 1 3.16 4.545l9.613-2.757c1.06-.304 2.17.311 2.474 1.371l.397 1.386H7.018C5 4.545 4 6.018 4 7v7.732L1.788 7.018Z" />
                </g>
                <path fill="#fff" d="M7 5.581c-1.103 0-2 .897-2 2v10c0 1.104.897 2 2 2h7v-3.5a1.5 1.5 0 0 1 1.5-1.5H19v-7c0-1.103-.897-2-2-2H7Zm12 10h-3.5c-.275 0-.5.226-.5.5v3.5l1-1 2-2 1-1Z" />
              </g>
              <defs>
                <clipPath id="a">
                  <path fill="#fff" d="M0 0h20v20.58H0z" />
                </clipPath>
                <clipPath id="b">
                  <path fill="#fff" d="M0 4.41 15.38 0l4.41 15.38-15.38 4.41z" />
                </clipPath>
              </defs>
            </svg><?= l("create_biolink_note_modal.note_list") ?></a>
        </div>
      </div>

      <div class="modal-body p-0 p-sm-3">
        <form id="<?= 'note_form_' . $data->link->biolink_block_id ?>" method="post" role="form">
          <input type="hidden" name="token" value="<?= \Altum\Middlewares\Csrf::get() ?>" required="required" />
          <input type="hidden" name="biolink_block_id" value="<?= $data->link->biolink_block_id ?>" />
          <input type="hidden" name="google-token" value="<?php if (isset($_GET['code'])) echo $_GET['code']; ?>">
          <input type="hidden" name="timezone" id="timezone" value="">

          <div class="notification-container"></div>

          <div class="form-group">
            <label for="title"><i class="fa fa-fw fa-signature fa-sm text-muted mr-1"></i><?= l('create_biolink_faq_modal.title') ?></label>
            <input type="text" class="form-control form-control-lg" name="title" maxlength="128" required="required" placeholder="<?= $data->link->settings->title_placeholder ?>" aria-label="<?= $data->link->settings->title_placeholder ?>" />
          </div>

          <div class="form-group mb-4">
            <label for="content"><i class="fa fa-fw fa-pen fa-sm text-muted mr-1"></i><?= l('create_biolink_faq_modal.content') ?></label>
            <textarea class="form-control" name="content" maxlength="32000" rows="4" cols="32" required="required" placeholder="<?= $data->link->settings->content_placeholder ?>" aria-label="<?= $data->link->settings->content_placeholder ?>"></textarea>
          </div>

          <div class="custom-control custom-switch form-group">
            <input type="checkbox" class="custom-control-input" id="google_calendar" name="google_calendar">
            <label class="custom-control-label clickable" for="google_calendar"><?= l('create_biolink_note_modal.google_calendar') ?></label>
          </div>

          <div class="google_calendar_input d-none">
            <div class="form-group">
              <label for="start_date"><?= l("link.settings.start_date") ?></label>
              <input type="date" class="form-control" name="start_date"></input>
            </div>

            <div class="form-group">
              <label for="end_date"><?= l("link.settings.end_date") ?></label>
              <input type="date" class="form-control" name="end_date"></input>
            </div>

            <div class="form-group">
              <label for="start_time"><?= l("create_biolink_note_modal.input.event_start_datetime") ?></label>
              <input type="time" class="form-control" name="start_time"></input>
            </div>

            <div class="form-group">
              <label for="end_time"><?= l("create_biolink_note_modal.input.event_end_datetime") ?></label>
              <input type="time" class="form-control" name="end_time"></input>
            </div>

            <div class="form-group">
              <label for="location"><?= l("create_biolink_note_modal.input.event_localization") ?></label>
              <input type="text" class="form-control" name="location" placeholder="<?= l("create_biolink_note_modal.input.event_localization_placeholder") ?>"></input>
            </div>
          </div>

          <!-- <?php if ($data->link->settings->show_agreement) : ?>
            <div class="d-flex align-items-center">
              <input type="checkbox" id="agreement" name="agreement" class="mr-3" required="required" />
              <label for="agreement" class="text-muted mb-0">
                <a href="<?= $data->link->settings->agreement_url ?>">
                <?= $data->link->settings->agreement_text ?>
                </a>
              </label>
            </div>
          <?php endif ?> -->

          <?php if (settings()->captcha->type != 'basic') : ?>
            <div class="form-group">
              <?php (new \Altum\Captcha())->display() ?>
            </div>
          <?php endif ?>

          <div class="text-center mt-4">
            <button type="submit" name="submit" class="btn btn-block btn-primary" data-toggle="modal" data-target="<?= 'note_' . $data->link->biolink_block_id . '_2' ?>"><?= $data->link->settings->button_text ?></button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<?php \Altum\Event::add_content(ob_get_clean(), 'modals') ?>


<?php if (!\Altum\Event::exists_content_type_key('javascript', 'note')) : ?>
  <?php ob_start() ?>
  <script>
    'use strict';

    function toggleGoogleCalendarInputs(enable) {
      document.querySelectorAll('.google_calendar_input').forEach(element => {
        element.classList.toggle('d-none', !enable);
        const input = element.querySelector('div input');
        if (input && input.name === "start_date") {
          input.required = enable;
        }
      });
    }

    function saveFieldsToLocal(biolink_block_id) {
      [document.querySelector('input[name="title"'), document.querySelector('textarea[name="content"')].forEach(element => {
        if (element) {
          localStorage.setItem(element.name + biolink_block_id, element.value);
        }
      });
    }

    const biolink_block_id = '_' + document.querySelector('input[name^="biolink_block_id"]').value;
    const authUrl = 'https://accounts.google.com/o/oauth2/v2/auth?client_id=&redirect_uri=&response_type=code&scope=https://www.googleapis.com/auth/calendar';
    const google_calendar = document.getElementById('google_calendar');
    const code = new URLSearchParams(window.location.search);

    if (code.get('code')) {
      google_calendar.checked = true;
      $('form .form-control').each((index, element) => {
        const item = localStorage.getItem(element.name + biolink_block_id);
        if (item) element.value = item;
      })
      document.querySelector('a[data-target]').click();
      toggleGoogleCalendarInputs(true);
    }

    google_calendar.addEventListener('change', (event) => {
      if (event.target.checked && !code.get('code')) {
        saveFieldsToLocal(biolink_block_id);
        window.location.href = authUrl;
      } else {
        toggleGoogleCalendarInputs(event.target.checked);
      }
    })

    // Set timezone
    document.getElementById('timezone').value = Intl.DateTimeFormat().resolvedOptions().timeZone;

    /* Form handling for note submissions if any */
    $('form[id^="note_"]').on('submit', event => {
      $.ajax({
        type: 'POST',
        url: `${site_url}l/link/note`,
        data: $(event.currentTarget).serialize(),
        success: (data) => {
          let notification_container = event.currentTarget.querySelector('.notification-container');
          notification_container.innerHTML = '';

          if (data.status == 'error') {
            display_notifications(data.message, 'error', notification_container);
          } else if (data.status == 'success') {
            display_notifications(data.message, 'success', notification_container);

            setTimeout(() => {
              /* Hide modal */
              $(event.currentTarget).closest('.modal').modal('hide');

              /* Remove the notification */
              notification_container.innerHTML = '';

              if (data.details.thank_you_url) {
                window.location.replace(data.details.thank_you_url);
              }
            }, 1000);
          }

          /* Reset captcha */
          try {
            grecaptcha.reset();
            hcaptcha.reset();
          } catch (error) {}
        },
        dataType: 'json'
      });

      // Clear localStorage items
      Object.keys(localStorage).forEach(key => {
        if (key.endsWith(biolink_block_id))
          localStorage.removeItem(key);
      });

      // Clear url parameters
      const url = new URL(window.location);
      url.search = '';
      window.history.replaceState({}, document.title, url);
    })
  </script>
  <?php \Altum\Event::add_content(ob_get_clean(), 'javascript', 'note') ?>
<?php endif ?>